# ---------- Данные ----------
# Вес Петиных интересов
petya_weights = {
    'футбол': 3,
    'техника': 2,
    'фильмы': 1
}
# Интересы друзей,  сопоставленные с общими категориями
friends_interests = {
    'Ваня':  ['футбол', 'техника', 'фильмы'],   # баскетбол → футбол, Android → техника, DC → фильмы
    'Катя':   [],                                 # никакого совпадения
    'Миша':   ['техника', 'фильмы']     # Samsung → техника, Marvel‑комиксы → фильмы
}
# ---------- Вычисление оценок ----------
def similarity_score(interests):
    """Суммируем веса Пети для всех совпавших категорий."""
    return sum(petya_weights[cat] for cat in interests)
scores = {friend: similarity_score(ints)
          for friend, ints in friends_interests.items()}
# ---------- Выбор лучшего друга ----------
best_friend = max(scores, key=scores.get)
# ---------- Вывод ----------
print("Оценки сходства:")
for f, s in scores.items():
    print(f"  {f}: {s}")
print(f"\nСамый подходящий подарок: {best_friend}")
